﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Ksiega" %>
<script runat="server">

	public class Params: ContextBase {
	
		public Params(Context context): base(context) {
			object obj = LoadProperty(NazwaPola, NazwaKategorii);
            narzedziaKsiegowe = obj == null ? false : (bool)obj;
			obj = LoadProperty(NazwaPola2, NazwaKategorii);
            wylChron = obj == null ? false : (bool)obj;
		}

		bool narzedziaKsiegowe = false;
		[Caption("Narzędzia księgowe")]
      public bool NarzedziaKsiegowe {
          get { return narzedziaKsiegowe; }
			set {
              narzedziaKsiegowe = value; 
				OnChanged(EventArgs.Empty);
			}
		}

				bool wylChron = false;
		[Caption("Wył. chron. tworz. dek.")]
      public bool WyłączenieChronologii {
          get { return wylChron; }
			set {
              wylChron = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}

	Params pars;
	[Context]
	public Params Pars {
		get { return pars; }
		set { pars = value; }
	}

    void dc_ContextLoad(Object sender, EventArgs e) {
			object obj = pars.LoadProperty(NazwaPola, NazwaKategorii);
			bool narzedziaKsiegowe = obj == null ? false : (bool)obj;			
			obj = pars.LoadProperty(NazwaPola2, NazwaKategorii);
			bool wylChron = obj == null ? false : (bool)obj;			
			if (pars.WyłączenieChronologii==wylChron && pars.NarzedziaKsiegowe==narzedziaKsiegowe)
				throw new Exception("Nie zmieniono ustawienia - identyczne z aktualnym");

			pars.SaveProperty(NazwaPola, NazwaKategorii);
			pars.SaveProperty(NazwaPola2, NazwaKategorii);
		
		throw new CancelException();
    }
    
	static void Msg(object value) {
	}
	
	static public string NazwaKategorii = "ksiega";
	static public string NazwaPola = "NarzedziaKsiegowe";	
	static public string NazwaPola2 = "WyłączenieChronologii";	

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Usuwanie podlegania rozliczeniom</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    </form>
</body>
</html>
